/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSpinLockImpDrvNT.h,v 1.2 1999/09/17 04:20:51 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSpinLockImpDrvNT_h	// [
#define Included_CSpinLockImpDrvNT_h

#include "pgpClassesConfig.h"
#include "CSpinLockImp.h"

_PGP_BEGIN

// Class CSpinLockImpDrvNT

class CSpinLockImpDrvNT : public CSpinLockImp
{
	friend class CPFLImpFactoryDrvNT;

private:
	CSpinLockImpDrvNT() {KeInitializeSpinLock(&mSpinLock);}

	void	Lock() {KeAcquireSpinLock(&mSpinLock, &mOldIrql);}
	void	Unlock() {KeReleaseSpinLock(&mSpinLock, mOldIrql);}

private:
	mutable KIRQL	mOldIrql;
	KSPIN_LOCK		mSpinLock;
};

_PGP_END

#endif	// ] Included_CSpinLockImpDrvNT_h
